<?php
	session_start();
	if ($_SESSION['unohs'] == null) {
		header("location:index.php?msg=unauthorized");
	}

	include ("conn.php");

 // Helper function to get days in month
   function getDaysInMonth($month, $year) {
    return (int)date('t', strtotime("$year-$month-01"));
}

    $apiData = [];
    $daysInMonth = 0;
    $selectedMonth = date('n');
    $selectedYear = date('Y');
    $selectedLanguage = 1;
    $selectedLv = -1;
    $selectedPageNo = 1;
    $selectedPageSize = 1000;
    $selectedUserId = '';

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fetch_report'])) {
        $selectedMonth = intval($_POST['month']);
        $selectedYear = intval($_POST['year']);
        $selectedLanguage = intval($_POST['language']);
        $selectedLv = intval($_POST['lv']);
        $selectedPageNo = intval($_POST['pageNo']);
        $selectedPageSize = intval($_POST['pageSize']);
        $selectedUserId = trim($_POST['userId']);

        $daysInMonth = getDaysInMonth($selectedMonth, $selectedYear);

        $apiUrl = "https://91xwin.site/api/webapi/adminTeamDayReport.php?month={$selectedMonth}&year={$selectedYear}&language={$selectedLanguage}&lv={$selectedLv}&pageNo={$selectedPageNo}&pageSize={$selectedPageSize}&userId={$selectedUserId}";

        $response = @file_get_contents($apiUrl);
        if ($response !== false) {
            $json = json_decode($response, true);
            if (isset($json['data']) && is_array($json['data'])) {
                // Index data by day for easy lookup
                foreach ($json['data'] as $row) {
                    if (isset($row['day'])) {
                        $apiData[intval($row['day'])] = $row;
                    }
                }
            }
        }
    } else {
        $daysInMonth = getDaysInMonth($selectedMonth, $selectedYear);
    }


    if (isset($_POST['redserial'])) {
        $a_id = $_POST['redserial'];
        $ch_s1 = "UPDATE hodike_nirvahaka SET shonu='2' WHERE enserie='" . $a_id . "'";
        $exe_ch_s1 = mysqli_query($conn, $ch_s1);
        if (!$exe_ch_s1) {
            die('Error: ' . mysqli_error($conn)); // Display error message if the update query fails
        }
    }
?>

<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>Dashboard</title>
	<link rel="stylesheet" href="vendors/mdi/css/materialdesignicons.min.css">
	<link rel="stylesheet" href="vendors/feather/feather.css">
	<link rel="stylesheet" href="vendors/base/vendor.bundle.base.css">
	<link rel="stylesheet" href="vendors/flag-icon-css/css/flag-icon.min.css"/>
	<link rel="stylesheet" href="vendors/font-awesome/css/font-awesome.min.css">
	<link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars-o.css">
	<link rel="stylesheet" href="vendors/jquery-bar-rating/fontawesome-stars.css">
	<link rel="stylesheet" href="css/style.css">
	<link rel="stylesheet" href="plugins/datatables/dataTables.bootstrap.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.2.3/css/fixedHeader.dataTables.min.css">
	<link rel="shortcut icon" href="images/favicon.png" />
	<style>
		.cool-input {
			border: 2px solid #007bff;
			border-radius: 0.25rem;
			padding: 0.5rem 1rem;
			font-size: 1rem;
			transition: all 0.3s ease;
		}
		.cool-input:focus {
			border-color: #0056b3;
			box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
		}
		.cool-input::placeholder {
			color: #6c757d;
			opacity: 1;
		}
		.cool-button {
			padding: 0.5rem 1rem;
			font-size: 1rem;
			border-radius: 0.25rem;
			transition: all 0.3s ease;
		}
		.cool-button:hover {
			background-color: #0056b3;
			color: #fff;
		}
		.cool-button.btn-secondary:hover {
			background-color: #343a40;
			color: #fff;
		}
		#copied {
			visibility: hidden;
			z-index: 1;
			position: fixed;
			bottom: 50%;
			background-color: #333;
			color: #fff;
			border-radius: 6px;
			padding: 16px;
			max-width: 250px;
			font-size: 17px;
		}
		#copied.show {
			visibility: visible;
			-webkit-animation: fadein 0.5s, fadeout 0.5s 2.5s;
			animation: fadein 0.5s, fadeout 0.5s 2.5s;
		}
	</style>
</head>

<body>
	<div class="container-scroller">
		<nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
			<div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
				<a class="navbar-brand brand-logo" href="dashboard.php"><img src="images/logo.png" alt="logo" /></a>
				<a class="navbar-brand brand-logo-mini" href="dashboard.php"><img src="images/logo-mini.png" alt="logo" /></a>
			</div>
			<div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
				<button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
					<span class="icon-menu"></span>
				</button>
				<ul class="navbar-nav navbar-nav-right">
					<li class="nav-item dropdown d-flex mr-4 ">
						<a class="nav-link count-indicator dropdown-toggle d-flex align-items-center justify-content-center" id="notificationDropdown" href="#" data-toggle="dropdown">
							<i class="icon-cog"></i>
						</a>
						<div class="dropdown-menu dropdown-menu-right navbar-dropdown preview-list" aria-labelledby="notificationDropdown">
							<p class="mb-0 font-weight-normal float-left dropdown-header">Settings</p>
							<a class="dropdown-item preview-item" href="logout.php">
								<i class="icon-inbox"></i> Logout
							</a>
						</div>
					</li>
				</ul>
				<button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
					<span class="icon-menu"></span>
				</button>
			</div>
		</nav>
		<div class="container-fluid page-body-wrapper">
			<nav class="sidebar sidebar-offcanvas" id="sidebar">
				<div class="user-profile">
					<div class="user-image">
						<img src="images/faces/face28.png">
					</div>
					<div class="user-name"></div>
					<div class="user-designation">
						Developer
					</div>
				</div>
				<?php include 'compass.php'; ?>
			</nav>
			<div class="main-panel">
    <div class="content-wrapper">
        <!-- API Parameter Form -->
        <div class="card mb-4">
            <div class="card-body">
                <h4 class="card-title">Fetch Team Day Report</h4>
                <form method="POST" class="row g-3">
                    <div class="col-md-2">
                        <label for="month" class="form-label">Month</label>
                        <input type="number" min="1" max="12" class="form-control cool-input" id="month" name="month" value="<?php echo htmlspecialchars($selectedMonth); ?>" required>
                    </div>
                    <div class="col-md-2">
                        <label for="year" class="form-label">Year</label>
                        <input type="number" min="2000" max="2100" class="form-control cool-input" id="year" name="year" value="<?php echo htmlspecialchars($selectedYear); ?>" required>
                    </div>
                    <div class="col-md-2">
                        <label for="language" class="form-label">Language</label>
                        <input type="number" class="form-control cool-input" id="language" name="language" value="<?php echo htmlspecialchars($selectedLanguage); ?>" required>
                    </div>
                    <div class="col-md-2">
                        <label for="lv" class="form-label">LV</label>
                        <input type="number" class="form-control cool-input" id="lv" name="lv" value="<?php echo htmlspecialchars($selectedLv); ?>" required>
                    </div>
                    <div class="col-md-2">
                        <label for="pageNo" class="form-label">Page No</label>
                        <input type="number" class="form-control cool-input" id="pageNo" name="pageNo" value="<?php echo htmlspecialchars($selectedPageNo); ?>" required>
                    </div>
                    <div class="col-md-2">
                        <label for="pageSize" class="form-label">Page Size</label>
                        <input type="number" class="form-control cool-input" id="pageSize" name="pageSize" value="<?php echo htmlspecialchars($selectedPageSize); ?>" required>
                    </div>
                    <div class="col-md-3 mt-2">
                        <label for="userId" class="form-label">User ID</label>
                        <input type="text" class="form-control cool-input" id="userId" name="userId" value="<?php echo htmlspecialchars($selectedUserId); ?>" required>
                    </div>
                    <div class="col-md-3 mt-4">
                        <button type="submit" name="fetch_report" class="btn btn-primary cool-button">Fetch Report</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Table Display -->
        <?php if (!empty($selectedUserId)): ?>
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Team Day Report for <?php echo "{$selectedMonth}/{$selectedYear}"; ?></h4>
                <div class="table-responsive">
                  <table class="table table-bordered" id="reportTable">
    <thead>
        <tr>
            <th>Date</th>
            <th>Recharge Count</th>
            <th>Recharge Amount</th>
            <th>First Recharge Count</th>
            <th>First Recharge Amount</th>
            <th>Withdrawal Amount</th>
            <th>Rebate Amount</th>
            <th>Bet Count</th>
            <th>Bet Amount</th>
            <th>Profit</th>
            <th>Loss</th>
            <th>Total Refers</th>
            <th>Level 1 Betters</th>
        </tr>
    </thead>
    <tbody>
        <?php
        // Prepare a map of date => data for easy lookup
        $monthlyDataMap = [];
        if (isset($json['data']['monthlyData']) && is_array($json['data']['monthlyData'])) {
            foreach ($json['data']['monthlyData'] as $dayData) {
                $date = $dayData['date'];
                $monthlyDataMap[$date] = $dayData['data'];
            }
        }

        // Get all days in the selected month
        for ($d = 1; $d <= $daysInMonth; $d++):
            $dateStr = sprintf('%04d-%02d-%02d', $selectedYear, $selectedMonth, $d);
            $data = isset($monthlyDataMap[$dateStr]) ? $monthlyDataMap[$dateStr] : null;
        ?>
        <tr>
            <td><?php echo htmlspecialchars($dateStr); ?></td>
            <td><?php echo $data ? htmlspecialchars($data['recahrgeCount']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['recahrgeAmountSum']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['firstRecahrgeCount']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['firstRecahrgeAmountSum']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['withdrawalAmountSum']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['rebateAmountSum']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['betCountSum']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['betAmountSum']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['profit']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['loss']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['totalRefers']) : ''; ?></td>
            <td><?php echo $data ? htmlspecialchars($data['level1BettersCount']) : ''; ?></td>
        </tr>
        <?php endfor; ?>
    </tbody>
</table>
                </div>
            </div>
        </div>
        <?php endif; ?>

				</div>
				<footer class="footer">
					<div class="d-sm-flex justify-content-center justify-content-sm-between">
						<span class="text-muted d-block text-center text-sm-left d-sm-inline-block">Copyright © Igaming Developers</span>
					</div>
				</footer>
			</div>
		</div>
	</div>
	<script src="vendors/base/vendor.bundle.base.js"></script>
	<script src="js/off-canvas.js"></script>
	<script src="js/hoverable-collapse.js"></script>
	<script src="js/template.js"></script>
	<script src="vendors/chart.js/Chart.min.js"></script>
	<script src="vendors/jquery-bar-rating/jquery.barrating.min.js"></script>
	<script src="js/dashboard.js"></script>
	<script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
	<script>
		if (window.history.replaceState) {
			window.history.replaceState(null, null, window.location.href);
		}
	</script>
</body>

</html>
